/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest.cloning;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.SaveRestoreData;
import com.ibm.hwmca.base.saverest.SaveRestoreUtil;
import com.ibm.hwmca.base.saverest.cloning.CloningConstants;
import com.ibm.hwmca.base.saverest.cloning.CloningErrorIds;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CloningUtil
extends SaveRestoreUtil
implements CloningConstants,
CloningErrorIds {
    private static final String TRACE_MASKT = "XSRDCU T";
    private static final String TRACE_MASKF = "XSRDCU F";
    private static final String TRACE_MASKD = "XSRDCU D";
    private Set supportingMachines;
    private Set selectedMachines;

    public CloningUtil() {
        this.buildSupportingMachines();
    }

    void buildSupportingMachines() {
        FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.base.saverest.cloning.CloningToken", 1.0);
        this.supportingMachines = FcsServer.getFcsServer().getSupportingMachines(serviceId);
    }

    public LocalizableText[] getSupportingMachines() {
        LocalizableText[] machineNames = new LocalizableText[this.supportingMachines.size()];
        int i = 0;
        Iterator iterator = this.supportingMachines.iterator();
        while (iterator.hasNext()) {
            MachineId machineId = (MachineId)iterator.next();
            machineNames[i] = new LocalizableText(machineId.getName());
            Trace.trace(TRACE_MASKD, "machineNames[" + i + "]:" + machineNames[i].toString());
            ++i;
        }
        return machineNames;
    }

    public void setSelectedMachines(LocalizableText[] selections) {
        this.selectedMachines = new HashSet();
        Iterator iterator = this.supportingMachines.iterator();
        while (iterator.hasNext()) {
            MachineId machineId = (MachineId)iterator.next();
            int i = 0;
            while (i < selections.length) {
                if (machineId.getName().equals(selections[i].toString())) {
                    this.selectedMachines.add(machineId);
                    Trace.trace(TRACE_MASKD, "found machine: " + selections[i].toString());
                    i = selections.length;
                }
                ++i;
            }
        }
    }

    public MachineId[] getSelectedMachineIds() {
        if (this.selectedMachines != null) {
            return this.selectedMachines.toArray(new MachineId[this.selectedMachines.size()]);
        }
        return new MachineId[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    CompletionReport[] cloneItems(String[] selectedStrings) {
        Trace.trace(TRACE_MASKT, "-> CloningUtil.cloneItems()");
        HashMap<String, Serializable> saveItems = new HashMap<String, Serializable>();
        int i = 0;
        while (i < selectedStrings.length) {
            int underscore = selectedStrings[i].indexOf(95);
            int impl = Integer.parseInt(selectedStrings[i].substring(0, underscore));
            int item = Integer.parseInt(selectedStrings[i].substring(underscore + 1));
            SaveRestoreData implClass = (SaveRestoreData)this.implList.get(impl);
            Serializable obj = implClass.getItem(((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey());
            saveItems.put(((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey(), obj);
            ++i;
        }
        Trace.trace(TRACE_MASKF, "Cloning saveItems size: " + saveItems.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloningAction", "SaveButton");
        map.put("dataMap", saveItems);
        FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.base.saverest.cloning.CloningToken", 1.0);
        CompletionReport[] reports = new CompletionReport[this.selectedMachines.size()];
        int i2 = 0;
        Iterator iterator = this.selectedMachines.iterator();
        while (iterator.hasNext()) {
            Trace.trace(TRACE_MASKD, "connecting to new machine");
            MachineId machineId = (MachineId)iterator.next();
            FcsConnection connection = null;
            connection = FcsConnection.connect(machineId, serviceId);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(map);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            reports[i2] = (CompletionReport)ois.readObject();
            Trace.trace(TRACE_MASKD, "read in completion report");
            Object var15_19 = null;
            try {
                connection.getSocket().close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            ++i2;
            {
                continue;
                catch (Exception e) {
                    reports[i2] = new CompletionReport(null, CompletionReportCode.FAIL);
                    new FrameworkLog(CloningErrorIds._logInfo, 264, e).log(FrameworkLogAttributes.INFO_LOG);
                    var15_19 = null;
                    try {
                        connection.getSocket().close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    ++i2;
                    continue;
                }
            }
            catch (Throwable throwable) {
                var15_19 = null;
                try {
                    connection.getSocket().close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                ++i2;
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- CloningUtil.cloneItems()");
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    CompletionReport beCloned(String[] selectedStrings) {
        CompletionReport report;
        block8: {
            Trace.trace(TRACE_MASKT, "-> beCloned()");
            String[] stringArray = this.buildListOfNeededItems(selectedStrings);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cloningAction", "RestoreButton");
            map.put("uiInfoArray", stringArray);
            FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.base.saverest.cloning.CloningToken", 1.0);
            FcsConnection connection = null;
            Iterator iterator = this.selectedMachines.iterator();
            MachineId machineId = (MachineId)iterator.next();
            iterator = null;
            connection = FcsConnection.connect(machineId, serviceId);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(map);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            Map dataMap = (Map)ois.readObject();
            report = this.receiveClonedData(dataMap);
            Trace.trace(TRACE_MASKD, "received our data report");
            Object var13_13 = null;
            try {
                connection.getSocket().close();
            }
            catch (Exception e2) {}
            break block8;
            {
                catch (Exception e) {
                    report = new CompletionReport(null, CompletionReportCode.FAIL);
                    new FrameworkLog(CloningErrorIds._logInfo, 265, e).log(FrameworkLogAttributes.INFO_LOG);
                    Object var13_14 = null;
                    try {
                        connection.getSocket().close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    connection.getSocket().close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- beCloned()");
        return report;
    }

    String[] buildListOfNeededItems(String[] selectedStrings) {
        String[] stringArray = new String[selectedStrings.length];
        int i = 0;
        while (i < selectedStrings.length) {
            int underscore = selectedStrings[i].indexOf(95);
            int impl = Integer.parseInt(selectedStrings[i].substring(0, underscore));
            int item = Integer.parseInt(selectedStrings[i].substring(underscore + 1));
            stringArray[i] = ((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey();
            ++i;
        }
        return stringArray;
    }

    Map buildRequestedData(String[] requestedItems) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Iterator iterator = this.implList.iterator();
        while (iterator.hasNext()) {
            SaveRestoreData implClass = (SaveRestoreData)iterator.next();
            int i = 0;
            while (i < requestedItems.length) {
                Serializable obj = implClass.getItem(requestedItems[i]);
                if (obj != null) {
                    map.put(requestedItems[i], obj);
                }
                ++i;
            }
        }
        return map;
    }

    CompletionReport receiveClonedData(Map map) {
        Trace.trace(TRACE_MASKT, "-> CloningUtil.receiveClonedData()");
        Object implClass = null;
        int badItems = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String objId = (String)iterator.next();
            Serializable obj = (Serializable)map.get(objId);
            boolean found = false;
            int implOffset = -1;
            int i = 0;
            Iterator itemsIterator = this.saveableItems.iterator();
            while (itemsIterator.hasNext()) {
                if (!found) {
                    CustomizableData[] customArray = (CustomizableData[])itemsIterator.next();
                    int z = 0;
                    while (z < customArray.length) {
                        if (customArray[z].getCustomDataKey().equals(objId)) {
                            found = true;
                            implOffset = i;
                        }
                        ++z;
                    }
                    ++i;
                    continue;
                }
                itemsIterator.next();
            }
            if (implOffset >= 0) {
                Trace.trace(TRACE_MASKF, "we found our item");
                SaveRestoreData impl = (SaveRestoreData)this.implList.get(implOffset);
                impl.setItem(objId, obj);
                continue;
            }
            Trace.trace(TRACE_MASKF, "we didn't find our item");
            ++badItems;
        }
        CompletionReport report = new CompletionReport();
        if (badItems == 0) {
            report.setCompletionCode(CompletionReportCode.SUCCESS);
        } else if (badItems == map.keySet().size()) {
            report.setCompletionCode(CompletionReportCode.FAIL);
        } else {
            report.setCompletionCode(CompletionReportCode.PARTIAL_SUCCESS);
        }
        Trace.trace(TRACE_MASKT, "<- CloningUtil.receiveClonedData()");
        return report;
    }
}

